import express from "express";
import jwt from "jsonwebtoken";
import cors from "cors";
import { AccessToken } from "livekit-server-sdk";

const app = express();
app.use(cors());
app.use(express.json());

app.post("/get-token", (req, res) => {
  const { room, username } = req.body;

  const token = new AccessToken(
    process.env.LIVEKIT_API_KEY,
    process.env.LIVEKIT_API_SECRET,
    { identity: username }
  );

  token.addGrant({ roomJoin: true, room });

  res.json({ token: token.toJwt() });
});

app.listen(5000, () => console.log("LiveKit token server running"));
