import React, { useEffect, useState } from "react";
import { View } from "react-native";
import { LiveKitRoom } from "@livekit/react-native";
import LiveCaptionsBar from "../components/LiveCaptionsBar";

export default function VideoRoom({ route }) {
  const { token } = route.params;
  const [caption, setCaption] = useState("");

  useEffect(() => {
    const ws = new WebSocket("wss://yourserver.com:8080");

    ws.onmessage = e => {
      const data = JSON.parse(e.data);
      setCaption(data.caption);
    };

    return () => ws.close();
  }, []);

  return (
    <View style={{ flex: 1 }}>
      <LiveKitRoom
        serverUrl="wss://YOUR_LIVEKIT_URL"
        token={token}
        connect={true}
        audio={true}
        video={true}
        style={{ flex: 1 }}
      />

      <LiveCaptionsBar caption={caption} />
    </View>
  );
}
