import React from "react";
import { View, Text, StyleSheet } from "react-native";

export default function LiveCaptionsBar({ caption }) {
  if (!caption) return null;

  return (
    <View style={styles.container}>
      <Text style={styles.text}>{caption}</Text>
    </View>
  );
}

const styles = StyleSheet.create({
  container: {
    position: "absolute",
    bottom: 20,
    left: 10,
    right: 10,
    backgroundColor: "rgba(0,0,0,0.7)",
    padding: 12,
    borderRadius: 8
  },
  text: {
    color: "#fff",
    fontSize: 16,
    textAlign: "center"
  }
});
